<?php
/**
 * Project:                 sh404SEF - SEO extension for Joomla!
 *
 * @author                  Yannick Gaultier
 * @copyright               (c) Yannick Gaultier - Weeblr llc - 2021
 * @package                 sh404SEF
 * @license                 http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @version                 4.23.2.4269
 *
 * 2021-06-09
 */

namespace Weeblr\Wblib\V_SH4_4269\Platform\Joomla;

use Weeblr\Wblib\V_SH4_4269\System;

// Security check to ensure this file is being included by a parent file.
defined('_JEXEC') || defined('WBLIB_V_SH4_4269_ROOT_PATH') || die;

class Config implements System\ConfigInterface
{
	/**
	 * @var \JRegistry
	 */
	private $joomlaConfig = null;

	/**
	 * Config constructor. Stores Joomla config object
	 *
	 * @param   \JRegistry  $joomlaConfig
	 */
	public function __construct($joomlaConfig)
	{
		$this->joomlaConfig = $joomlaConfig;
	}

	/**
	 * Get a specific configuration key
	 *
	 * @param   string  $key      The config option name
	 * @param   mixed   $default  Optional default value if config not set
	 */
	public function get($key, $default = null)
	{
		return $this->joomlaConfig->get($key, $default);
	}

	/**
	 * Check if there exists a specific configuration key definition
	 *
	 * @param   string  $key
	 */
	public function hasConfigKey($key)
	{
		return $this->joomlaConfig->exists($key);
	}
}
