<?php
/**
 * Project:                 sh404SEF - SEO extension for Joomla!
 *
 * @author                  Yannick Gaultier
 * @copyright               (c) Yannick Gaultier - Weeblr llc - 2021
 * @package                 sh404SEF
 * @license                 http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @version                 4.23.2.4269
 *
 * 2021-06-09
 */

namespace Weeblr\Wblib\V_SH4_4269\Mvc;

use Weeblr\Wblib\V_SH4_4269\Wb;
/** ensure this file is being included by a parent file */
defined('_JEXEC') || defined('WBLIB_V_SH4_4269_ROOT_PATH') || die;

/**
 * Updates to a standard HTML page, which has an AMP version
 */
class ViewHtml extends ViewView
{
	protected $headers = array(
		'Content-Type'           => 'text/html; charset=utf-8',
		'X-Content-Type-Options' => 'nosniff',
		'x-wblib-version'        => 'v1'
	);

	/**
	 * Renders the view content, returning it in a string and
	 * optionally echoing it
	 */
	protected function doRender()
	{
		return LayoutHelper::render(
			Wb\dotJoin($this->theme, $this->layout),
			$this->data,
			$this->baseLayoutPath
		);
	}
}
