<?php
/**
 * Project:                 sh404SEF - SEO extension for Joomla!
 *
 * @author                  Yannick Gaultier
 * @copyright               (c) Yannick Gaultier - Weeblr llc - 2021
 * @package                 sh404SEF
 * @license                 http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @version                 4.23.2.4269
 *
 * 2021-06-09
 */

namespace Weeblr\Wblib\V_SH4_4269\Base;

use Weeblr\Wblib\V_SH4_4269\Wb;
use Weeblr\Wblib\V_SH4_4269\Factory;
use Weeblr\Wblib\V_SH4_4269\Platform\Platform;

/** ensure this file is being included by a parent file */
defined('_JEXEC') || defined('WBLIB_V_SH4_4269_ROOT_PATH') || die;

/**
 * Base class to access the factory.
 *
 */
class Base
{
	/**
	 * @var Factory Unique instance of the factory.
	 */
	protected $factory = null;

	/**
	 * @var Platform The platform instance.
	 */
	protected $platform = null;

	/**
	 * Stores factory instance.
	 *
	 * @param   array  $options  Can inject custom factory and platform.
	 */
	public function __construct($options = [])
	{
		$this->factory = Wb\arrayGet(
			$options,
			'factory',
			Factory::get()
		);

		$this->platform = Wb\arrayGet(
			$options,
			'platform',
			$this->factory->getThe('platform')
		);
	}
}
